' *************************************************************************************************************************
'
' 	This script will scan and show list with all installed USB-COM devices, including those not present.
'
' *************************************************************************************************************************

Set wshShell = WScript.CreateObject("WScript.Shell")
Set fso = CreateObject("Scripting.FileSystemObject")

USERNAME =  wshShell.ExpandEnvironmentStrings("%USERNAME%")

' Set script folder path.
scriptFullPath = Wscript.ScriptFullName
Set scriptPathObject = fso.GetFile(scriptFullPath)
scriptFolder = fso.GetParentFolderName(scriptPathObject)
driverFolder = scriptFolder & "\DRV"

' Show warning if not logged on as administrator user.
If not USERNAME = "Administrator" Then
	answerAdminError = MsgBox (("WARNING: You are not logged in as built-in Administrator user" & vbCr & vbCr &_
		"Some parts of this script requires Elevated Priviliges to run properly." & vbCr & vbCr &_
		"Would you like to continue anyway?"),4,("WARNING"))
	' Exit script if NO button was pressed.
	if answerAdminError = vbNo Then wscript.quit 0
End If

' Selecting devcon version depending on os architecture detected.
osArch = "NA"
osArch = wshShell.RegRead("HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\PROCESSOR_ARCHITECTURE")
devconFile = "devcon32.exe"
If osArch = "x86" then devconFile = "devcon32.exe"
If osArch = "AMD64" then devconFile = "devcon64.exe"
if osArch = "NA" Then MsgBox "Unable to detect OS architecture. Will use 32 bit version."

' Set driver/devcon folder as current folder.
WshShell.CurrentDirectory = driverFolder

deviceStatusFile = "USB-COM_All_Devices.txt"
if fso.FileExists(deviceStatusFile) Then fso.DeleteFile(deviceStatusFile)

wshShell.Run "%comspec% /C " & devconFile & " findall FTDIBUS*VID_0403*PID_601* > " & deviceStatusFile, 0, true
WScript.sleep 1000

If fso.FileExists(deviceStatusFile) Then
	wshShell.Run "%comspec% /C notepad " & deviceStatusFile, 0, false
Else
	MsgBox "An error occured, did not find any device list."
End If
